<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h5>Software Requirements</h5>
<p>To configure Verimatrix VCAS and Microsoft PlayReady encryption services using the Verimatrix DRM key management system, you must have a Verimatrix account.</p>

<p>Wowza DRM is required. If you purchased a license for Wowza media server software before January&nbsp;1,&nbsp;2015, contact <a href="mailto:sales@wowza.com">sales@wowza.com</a> to learn more about how to license Wowza DRM.</p>

<h5>Apple HLS Streaming Protection</h5>
<p>Select this option to enable encryption of Apple HLS streams using Verimatrix VCAS encryption services and then enter the following required information:</p>
<ul>
	<li><strong>Verimatrix Server/IP Address</strong>. The IP address or domain name of the Verimatrix HLS key server. You must contact Verimatrix to get the IP address.

	<li><strong>Verimatrix Server Port</strong>. The Verimatrix HLS key server scrambler port. You must contact Verimatrix to get the port value.

<c:if test="${appType=='vod'}"><li><strong>VOD Session Options</strong>. Select <strong>Use per-session keys</strong> to specify that a new position (key) is used for each new streaming session. When multiple positions are defined, the keys are rotated during playback. The same keys are used for each session of the same stream name. Not selecting this option means that a single key or set of keys is used for each new streaming session.</c:if>
</ul>

<h5>Microsoft Smooth Streaming Protection</h5>
<p>Select this option to enable encryption of Microsoft Smooth Streams using Microsoft PlayReady encryption services and then enter the following required information:</p>
<ul>
	<li><strong>Verimatrix Server/IP Address</strong>. The IP address or domain name of the Verimatrix PlayReady key server. You must contact Verimatrix to get the IP address.

	<li><strong>Verimatrix Server Port</strong>. The Verimatrix PlayReady key server scrambler port. You must contact Verimatrix to get the port value.
</ul>

<h5>Stream Name Mapping</h5>
<p>Specify the live or on demand sources to be encrypted by mapping stream names (for live sources) or file names (for on demand sources) to resource IDs and to control key rotation.</p>

<p>In <strong>Stream Name</strong>, you can use simple stream names or full file names to specify individual source items for encryption. Wildcard (&#42;) characters can't be used to map multiple source items for encryption. In addition, the stream name value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), double-dot (..), and tilde (&#126;) characters. You must match each <strong>Stream Name</strong> entry to the following values:</p>
<ul>
	<li><strong>Resource ID</strong>. Specifies a resource ID to use for the given stream name. The ID value can only contain alphanumeric characters and the following special characters: &#33; &#35; &#36; &#38; &#45; &#59; &#61; &#63; &#91; &#93; &#95; &#37;

	<li><strong>Position Count</strong>. Specifies the number of positions (keys) to use for key rotation while the stream is encrypted.

	<li><strong>Key Rotation Interval</strong>. Specifies how often (in milliseconds) keys are rotated during packetization (for live streams) or playback (for VOD streams).
</ul>

<p>For more information about additional values that you can use in these fields, see <a href="https://www.wowza.com/docs/how-to-set-up-verimatrix-drm#configStreamMap" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Map file details (verimatrixtreammap.txt)</a>.</p>

<blockquote><strong>Note:</strong> Key rotation isn't used if either the <strong>Position Count</strong> or <strong>Key Rotation Interval</strong> values are set to <strong>0</strong>.</blockquote>

<p>When a new stream is started or played, the server searches for the stream name and encryption is applied if a match is found in the mapping file.</p>

<h5>Playing Encrypted Streams</h5>
<p>To test playback of encrypted live and VOD Apple HLS streams, see <a href="https://www.wowza.com/docs/how-to-set-up-verimatrix-drm#testingCupertino" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Apple HLS playback</a>.</p>

<p>To test playback of encrypted live and VOD Microsoft Smooth Streams, see <a href="https://www.wowza.com/docs/how-to-set-up-verimatrix-drm#testingSmooth" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Smooth Streaming playback</a>.</p>

<p>If you're delivering a live stream, be sure to start the server and send the stream from your live source to the server.</p>