<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}
</c:set>
<wmsform:setpagetitle page="appconfig.drm" appName="${appName}"/>

<c:set var="pagename">
	<wmsform:getlocalestring page="appconfig.drm" obj="head"/>
</c:set>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<div class="col-md-5">
	      	<happ>${wmsutil:escapeHtml(appName)} ${pagename}</happ><br>
	      	<small class="text-muted"><wmsform:objvalue page="appConfig" obj="uiAppType"/></small>
		</div>
		<wmsform:applicationbuttons page="drm"/>
	</div>    
    <div style="margin-top:-10px">
    	<hr>
    </div>
    <div class="row">
		<div class="col-md-12"><p><wmsform:getlocalestring page="appconfig.drm" obj="header"/></p>
		</div>
	</div>
    <div class="row col-md-12">
		<p id="pageText"></p>
	</div>
	<c:choose>
		<c:when test="${requestScope.formData['buyDRMEnabled']=='true' || requestScope.formData['ezDRMEnabled']=='true' || requestScope.formData['verimatrixEnabled']=='true'}">
			<script>
		    	appTranID="appName=" +getGoodJqueryID("${appName}") + ":drm:enabled";
		    	$('[id="'+appTranID+'"]').show();
		    </script>
		</c:when>
		<c:otherwise>
			<script>
		    	appTranID="appName=" +getGoodJqueryID("${appName}") + ":drm:enabled";
		    	$('[id="'+appTranID+'"]').hide();
		    </script>
		</c:otherwise>
	</c:choose> 
	<fieldset>	
		<div class="row">
			<div class="col-md-6">
				<div class="well">
				<div class="row">
					<div class="col-md-6">
						<img src="img/buydrm.png" class="pull-left" style="width:207px;height:50px;" />
					</div>
					<div class="col-md-6">
						<img src="img/playready.png" class="pull-right" style="width:83px;height:50px;" />
					</div>
				</div>
				<div class="row">
					<div class="col-md-12">
						<br />
						<p><wmsform:getlocalestring page="appconfig.drm_buydrm" obj="description"/></p>
					</div>
				</div>
				<div class="row">
					<div class="col-md-12">
						<c:choose>
							<c:when test="${requestScope.formData['buyDRMEnabled']=='true' && requestScope.formData['licenseType']!='NotLicensed'}">
							<div class="text-center">
								<h5>Status: <span class="text-success"><i class="fa fa-lock"></i> Enabled</span></h5>
							</div>
								<div class="row">
									<sec:authorize access="!hasAnyRole('admin')">
										<div class="col-md-12">
									</sec:authorize>
									<sec:authorize access="hasAnyRole('admin')">
										<div class="col-md-6">
									</sec:authorize>
										<wmsform:button page="appconfig.drm" obj="settings" onClick="javascript:loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','drm_buydrm')" cssClass="btn btn-default btn-block"/>
									</div>
									<sec:authorize access="hasAnyRole('admin')">
										<div class="col-md-6">
											<wmsform:button page="appconfig.drm" obj="disableBuyDRM" onClick="javascript:loadAjaxMainContent('applications/${appType}/drm/disableDRM_BuyDRM.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" cssClass="btn btn-default btn-block"/>
										</div>
									</sec:authorize>
								</div>
							</c:when>
							<c:otherwise>
								<div class="text-center">
									<h5>Status: <i class="fa fa-unlock"></i> Not Enabled</h5>
								</div>
								<sec:authorize access="hasAnyRole('admin')">
									<c:if test="${requestScope.formData['licenseType']!='NotLicensed'}">		
										<wmsform:button page="appconfig.drm" obj="enableBuyDRM" onClick="javascript:loadAjaxMainContent('applications/${appType}/drm_buydrm/edit.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&action=enable')" cssClass="btn btn-default btn-block"/>
									</c:if>
								</sec:authorize>
							</c:otherwise>
						</c:choose>
					</div>
				</div>
			</div>
			</div>
			<div class="col-md-6">
				<div class="well">
					<div class="row">
						<div class="col-md-6">
							<img src="img/verimatrix.png" class="pull-left" style="width:134px;height:50px;" />
						</div>
						<div class="col-md-6">
							<img src="img/playready.png" class="pull-right" style="width:83px;height:50px;" />
						</div>
					</div>			  	
					<div class="row">
						<div class="col-md-12">
							<br />
							<p><wmsform:getlocalestring page="appconfig.drm_verimatrix" obj="description"/></p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<c:choose>
								<c:when test="${requestScope.formData['verimatrixEnabled']=='true' && requestScope.formData['licenseType']!='NotLicensed'}">
									<div class="text-center">
										<h5>Status: <span class="text-success"><i class="fa fa-lock"></i> Enabled</span></h5>
									</div>
										<div class="row">
											<sec:authorize access="!hasAnyRole('admin')">
												<div class="col-md-12">
											</sec:authorize>
											<sec:authorize access="hasAnyRole('admin')">
												<div class="col-md-6">
											</sec:authorize>
												<wmsform:button page="appconfig.drm" obj="settings" onClick="javascript:loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','drm_verimatrix')" cssClass="btn btn-default btn-block"/>
											</div>
											<sec:authorize access="hasAnyRole('admin')">
												<div class="col-md-6">
													<wmsform:button page="appconfig.drm" obj="disableVerimatrix" onClick="javascript:loadAjaxMainContent('applications/${appType}/drm/disableDRM_Verimatrix.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" cssClass="btn btn-default btn-block"/>
												</div>
											</sec:authorize>
										</div>
								</c:when>
								<c:otherwise>
									<div class="text-center">
										<h5>Status: <i class="fa fa-unlock"></i> Not Enabled</h5>
									</div>
									<sec:authorize access="hasAnyRole('admin')">
										<c:if test="${requestScope.formData['licenseType']!='NotLicensed'}">		
											<wmsform:button page="appconfig.drm" obj="enableVerimatrix" onClick="javascript:loadAjaxMainContent('applications/${appType}/drm_verimatrix/edit.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&action=enable')" cssClass="btn btn-default btn-block"/>
										</c:if>
									</sec:authorize>
								</c:otherwise>
							</c:choose>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-md-6">
				<div class="well">
					<div class="row">
						<div class="col-md-6">
							<img src="img/ezdrm.png" class="pull-left" style="width:84px;height:50px;" />
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">	
							<br />
							<p><wmsform:getlocalestring page="appconfig.drm_ezdrm" obj="description"/></p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<c:choose>
								<c:when test="${requestScope.formData['ezDRMEnabled']=='true' && requestScope.formData['licenseType']!='NotLicensed'}">
									<div class="text-center">
										<h5>Status: <span class="text-success"><i class="fa fa-lock"></i> Enabled</span></h5>
									</div>
									<div class="row">
										<sec:authorize access="!hasAnyRole('admin')">
											<div class="col-md-12">
										</sec:authorize>
										<sec:authorize access="hasAnyRole('admin')">
											<div class="col-md-6">
										</sec:authorize>
											<wmsform:button page="appconfig.drm" obj="settings" onClick="javascript:loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','drm_ezdrm')" cssClass="btn btn-default btn-block"/>
										</div>
										<sec:authorize access="hasAnyRole('admin')">
											<div class="col-md-6">
												<wmsform:button page="appconfig.drm" obj="disableEZDRM" onClick="javascript:loadAjaxMainContent('applications/${appType}/drm/disableDRM_EZDRM.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" cssClass="btn btn-default btn-block"/>
											</div>
										</sec:authorize>
									</div>
								</c:when>
								<c:otherwise>
									<div class="text-center">
										<h5>Status: <i class="fa fa-unlock"></i> Not Enabled</h5>
									</div>
									<sec:authorize access="hasAnyRole('admin')">
										<c:if test="${requestScope.formData['licenseType']!='NotLicensed'}">		
											<wmsform:button page="appconfig.drm" obj="enableEZDRM" onClick="javascript:loadAjaxMainContent('applications/${appType}/drm_ezdrm/edit.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&action=enable')" cssClass="btn btn-default btn-block"/>
										</c:if>
									</sec:authorize>
								</c:otherwise>
							</c:choose>
						</div>
					</div>
				</div>
			</div>
		</div>
	</fieldset>
</div>

<script>
	//need to force basic tab for enable drm
	lastTab="Basic";
</script>

<c:set var="licensedOnMsg">
	<wmsform:getlocalestring page="appconfig.drm" obj="licensedOn"/>
</c:set>
<c:set var="licensedOffMsg">
	<wmsform:getlocalestring page="appconfig.drm" obj="licensedOff"/>
</c:set>
<c:set var="notLicensedMsg">
	<wmsform:getlocalestring page="appconfig.drm" obj="notlicensed"/>
</c:set>

<script>
$('#AppStatus').hide();
$('#AppModules').hide();

$(document).ready(function() {
	if("${requestScope.formData['licenseType']}"=="NotLicensed")
	{
		$('#pageText').html('${notLicensedMsg}');	
	}
	else 
	{
		if("${requestScope.formData['licenseType']}"=="Daily" || "${requestScope.formData['licenseType']}"=="Monthly" )
		{
			if("${requestScope.formData['inUse']}"=="true")
			{
				$('#pageText').html('${licensedOnMsg}');	
			}
			else 
			{
				$('#pageText').html('${licensedOffMsg}');			
			}
		}
	}
});
</script>
