<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>

<div>
	<div id="generic.warnings" class="alert alert-warning" style="display:none"></div>
	<c:choose>
		<c:when test="${requestScope.formData['section']=='publishers_jvc'}">
			<re:mark>keep success messages closer to radios. defined in publishers_jvc/EditBasic.jsp</re:mark></c:when>
		<c:otherwise>
			<script>
			</script>
			<c:forEach var="msg" items="${formData.genericMessages}">
				<div class="row">
					<div class="col-md-12">
						<div class="alert alert-success">
							${msg}
						</div> 
					</div>
				</div>
			</c:forEach>
		</c:otherwise>
	</c:choose> 
	<div class="row">
		<div class="col-md-5">
			<happ>${wmsutil:escapeHtml(appName)} ${pagename}</happ><br>
			<small class="text-muted"><wmsform:objvalue page="appConfig" obj="uiAppType"/></small><br>
		</div>
		<wmsform:applicationbuttons page="${page}"/>
	</div>
	<div class="row col-md-12">
		<p id="pageText"></p>
	</div>

    <div id='applicationsTabs'class="row">
		<div class="col-md-12">
			<ul class="nav nav-tabs" >
				<li id="AppBasic" >
					<a href="javascript:showBasicTab()">Setup</a>
				</li>
				<li id="AppAdvanced" >
					<a href="javascript:showAdvTab()">Properties</a>
				</li>
				<li id="AppModules" >
					<a href="javascript:showModTab()">Modules</a>
				</li>
			</ul>
		</div>
	</div>
	<div id="applicationsNoTabs" class="notabs">
		<hr>
	</div>
	<sec:authorize access="hasAnyRole('advUser')">
		<script>
			$('#applicationsNoTabs').hide();
		</script>
	</sec:authorize>
	<sec:authorize access="!hasAnyRole('advUser')">
		<script>
			$('#applicationsTabs').hide();
		</script>
	</sec:authorize>
	<div class="row" id="tabContent">
        <div class="col-md-12">        
            <div class="row">
            	<c:choose>
	            	<c:when test="${mode=='view'}">
		                <div id="ViewMode">
		                    <div  id="TabBasic" style="display:none">
		                        <jsp:include page="ViewBasic.jsp" flush="true" />
		                    </div>
		                    <div id="TabAdv" style="display:none">
		                        <jsp:include page="ViewAdv.jsp" flush="true" />
		                    </div>
		                    <div id="TabMod" style="display:none">
			                    <c:import url="ViewMod.jsp"/>
		                    </div>
		                 </div>
	                 </c:when>
	                 <c:otherwise>
		                 <div id="EditMode">
		                    <div  id="TabEditBasic" style="display:none">
		                        <div class="col-md-8 main-content">
		                            <form:form method="post" commandName="formData" id="defaultForm">
		                                <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
		                                <wmsform:rightrailhideshow/>
		                                <jsp:include page="EditBasic.jsp" flush="true" />
		                                <%-- <form:hidden path="ignoreWarnings" /> --%>
		                            </form:form>
		                         </div>
		                         <div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
		                            <jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
		                        </div>
		                    </div>
		                    <div id="TabEditStatus" style="display:none">
		                        <jsp:include page="EditStatus.jsp" flush="true" />
		                    </div>
		                    <div id="TabEditAdv" style="display:none">
		                        <div class="col-md-12">
		                            <form:form method="post" commandName="formDataAdv" id="defaultFormAdv"> 
		                                <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
		                                <jsp:include page="EditAdv.jsp" flush="true" />
		                                <form:hidden path="ignoreWarnings" />	
		                            </form:form>
		                        </div>
		                    </div>
		                    <div id="TabEditMod" style="display:none">
		                        <div class="col-md-12">
		                            <form:form method="post" commandName="formDataMod" id="defaultFormMod"> 
		                                <wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
		                                <c:import url="EditMod.jsp"/>
		                                <form:hidden path="ignoreWarnings" />	
		                            </form:form>
		                        </div>
		                    </div>
		                </div>
	                </c:otherwise>
                </c:choose>
            </div>
		</div>
    </div>
   	<wmsform:setwarnings/>

	<c:if test="${reloadApplications}">
		<script>
			loadCurrentApplications();
		</script>
	</c:if>
</div>

<script>
$(document).ready(function() {
	<c:if test="${reloadApplciations}">
		loadCurrentApplications();
	</c:if>
	if(typeof(lastTab) === 'undefined') {
		lastTab="Basic";
	}
		
	if("${mode}"=="edit")
	{
		$('#ViewMode').hide();	
		$('#ViewModeButtons').hide();	
		$('#AppButtons').hide();
		$('#EditMode').show();				
		$('#EditModeButons').show();				
	}
	else 
	{
		$('#ViewMode').show();		
		$('#ViewModeButtons').show();		
		$('#AppButtons').show();
		$('#EditMode').hide();		
		$('#EditModeButtons').hide();		
	}
	if(lastTab=="Status")
	{
		showStatusTab();
	}
	else if(lastTab=="Advanced")
	{
		showAdvTab();
	}
	else if(lastTab=="Modules")
	{
		showModTab();
	}
	else {
		showBasicTab();		
	}
});

function showBasicTab() {
	if("${mode}"=="edit" && lastTab!='Basic')
	{
		lastTab='Basic';
		loadApplicationWithCollapse('${appName}','${appType}','${appSection}');
		return;
	}
	lastTab='Basic';
	createCookie("lastTab",lastTab);
	$('#TabBasic').show();
	$('#TabEditBasic').show();

	$('#TabStatus').hide();
	$('#TabEditStatus').hide();
	$('#HelpStatus').hide();
	
	$('#TabAdv').hide();
	$('#TabEditAdv').hide();
	
	$('#TabMod').hide();
	$('#TabEditMod').hide();
	
	$('#AppBasic').addClass('active');
	$('#AppStatus').removeClass();
	$('#AppAdvanced').removeClass();
	$('#AppModules').removeClass();
}

function showStatusTab() {
	if("${mode}"=="edit" && lastTab!='Status')
	{
		lastTab='Status';
		loadApplicationWithCollapse('${appName}','${appType}','${appSection}');
		return;
	}
	lastTab='Status';
	createCookie("lastTab",lastTab);

	$('#TabBasic').hide();
	$('#TabEditBasic').hide();
	
	$('#TabStatus').show();
	$('#TabEditStatus').show();
	$('#HelpStatus').show();

	$('#TabAdv').hide();
	$('#TabEditAdv').hide();
	
	$('#TabMod').hide();
	$('#TabEditMod').hide();

	$('#AppBasic').removeClass();
	$('#AppStatus').addClass('active');
	$('#AppAdvanced').removeClass();
	$('#AppModules').removeClass();
	
	loadAjaxContent("#TabStatus", "application/monitoring/monitor.htm",'vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}');
}

function showAdvTab() {
	if("${mode}"=="edit" && lastTab!='Advanced')
	{
		lastTab='Advanced';
		loadApplicationWithCollapse('${appName}','${appType}','${appSection}');
		return;
	}
	lastTab='Advanced';
	createCookie("lastTab",lastTab);

	$('#TabBasic').hide();
	$('#TabEditBasic').hide();
	
	$('#TabStatus').hide();
	$('#TabEditStatus').hide();
	$('#HelpStatus').hide();

	$('#TabAdv').show();
	$('#TabEditAdv').show();

	$('#TabMod').hide();
	$('#TabEditMod').hide();

	$('#AppBasic').removeClass();
	$('#AppStatus').removeClass();
	$('#AppAdvanced').addClass('active');	
	$('#AppModules').removeClass();
}

function showModTab() {
	if("${mode}"=="edit" && lastTab!='Modules')
	{
		lastTab='Modules';
		loadApplicationWithCollapse('${appName}','${appType}','${appSection}');
		return;
	}
	lastTab='Modules';
	createCookie("lastTab",lastTab);

	$('#TabBasic').hide();
	$('#TabEditBasic').hide();
	
	$('#TabStatus').hide();
	$('#TabEditStatus').hide();
	$('#HelpStatus').hide();

	$('#TabAdv').hide();
	$('#TabEditAdv').hide();

	$('#TabMod').show();
	$('#TabEditMod').show();

	$('#AppBasic').removeClass();
	$('#AppStatus').removeClass();
	$('#AppAdvanced').removeClass();
	$('#AppModules').addClass('active');
}

</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });


</script>
