#!/bin/bash
if [ -d /Library/WowzaStreamingEngine ]
then
	# OS X
	. /Library/WowzaStreamingEngine/manager/bin/setmgrenv.sh
else
	# Linux
	. /usr/local/WowzaStreamingEngine/manager/bin/setmgrenv.sh
fi


SHUTDOWN_WAIT=10
WMSBASE_NAME=WowzaStreamingEngineManager

kpid=`ps -ef | grep $WMSMGRCONFIG_HOME/lib/wms-tomcat | grep -v "grep" | awk '{print $2}'`
if [ -n "$kpid" ]; then
        echo -n "   $WMSBASE_NAME (PID: $kpid) is stopping..."
        let kwait=$SHUTDOWN_WAIT
        count=0;
        until [ `ps -p $kpid | grep -c $kpid` = '0' ] || [ $count -gt $kwait ]
        do
                kill $kpid
                echo -n  ".";
		sleep 1
                let count=$count+1;
        done

        if [ $count -gt $kwait ]; then
                echo -n -e   "\n\tKilling process: $WMSBASE_NAME ($kpid) which didn't stop after $SHUTDOWN_WAIT seconds\n"
                kill -9 $kpid
        fi

	echo -n -e "\tShutdown complete.\n\n"
else
        echo -n -e  "\n\t$WMSBASE_NAME: was not running.\n\n"
fi

# clean things up in case the service was running
WMSMGRPID_FILE="/var/run/$WMSBASE_NAME.pid"
WMSMGRLOCK_FILE="/var/run/$WMSBASE_NAME"
if test -w "/var/lock/subsys" ; then
	WMSMGRLOCK_FILE="/var/lock/subsys/$WMSMGRBASE_NAME"
fi
if [ -a $WMSMGRPID_FILE ]; then
	rm -f $WMSMGRPID_FILE
fi
if [ -a $WMSMGRLOCK_FILE ]; then
	rm -f $WMSMGRLOCK_FILE
fi

