<?php
require_once("admin/inc/protecao-final.php");

$total_avisos_ativos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos WHERE area = 'streaming'"));
$checar_status_aviso = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM avisos_desativados WHERE area = 'streaming' AND login = '".$dados_stm["login"]."'"));
$total_avisos_exibir = ($total_avisos_ativos > $checar_status_aviso) ? $total_avisos_ativos-$checar_status_aviso : 0;

$estatistica = query_string('1');
$mes = query_string('2');
$ano = query_string('3');

$total_espectadores_db = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));
$total_espectadores_unicos_db = mysqli_num_rows(mysqli_query($conexao,"SELECT DISTINCT ip FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));
$tempo_conectado = mysqli_fetch_array(mysqli_query($conexao,"SELECT count(tempo_conectado) as total_registros, SUM(tempo_conectado) as total_tempo FROM estatisticas WHERE codigo_stm = '".$dados_stm["codigo"]."'"));

$average_espectadores = $tempo_conectado["total_tempo"]/$tempo_conectado["total_registros"];

?>
<!doctype html>
<html lang="es" dir="ltr">
    <head>
        <meta charset="UTF-8">
        <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Streaming <?php echo $dados_stm["login"]; ?></title>
        <link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
        <link href="/inc/css/icons.css" rel="stylesheet">
        <link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
        <link href="/inc/css/theme.css" rel="stylesheet">
        <link href="/inc/css/theme-dark.css" rel="stylesheet">
        <link href="/inc/css/style-transparent.css" rel="stylesheet">
        <link href="/inc/css/skin-modes.css" rel="stylesheet" />
        <link href="/inc/css/animate.css" rel="stylesheet">
        <script type="text/javascript" src="/inc/ajax-streaming.js"></script>
        <script type="text/javascript" src="/inc/javascript.js"></script>
        <link rel="stylesheet" media="all" href="https://jvectormap.com/css/jquery-jvectormap-2.0.5.css"/>
        <script src="/inc/plugins/jquery/jquery.min.js"></script>
        <script src="https://code.highcharts.com/highcharts.js"></script>
        <script src="https://code.highcharts.com/highcharts-3d.js"></script>
        <script src="https://code.highcharts.com/modules/exporting.js"></script>
        <script src="https://jvectormap.com/js/jquery-jvectormap-2.0.5.min.js"></script>
        <script src="https://jvectormap.com/js/jquery-jvectormap-world-mill.js"></script>
    </head>
    <body class="ltr main-body app sidebar-mini <?php if($dados_stm["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
        <!-- Loader -->
        <div id="global-loader">
            <img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
        </div>
        <!-- /Loader -->
        <!-- Page -->
        <div class="page">
            <div class="open">
                <!-- main-header -->
                <?php require_once("header.php");?>             
                <!-- /main-header -->
                <!-- main-sidebar -->
                <div class="sticky">
                    <aside class="app-sidebar">
                        <div class="main-sidebar-header active">
                            <a class="header-logo active" href="/dashboard">
                                <?php if($dados_revenda["url_logo"]) { ?>
                                <img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-logo" alt="Painel Streaming">
                                <img src="<?php echo $dados_revenda["url_logo"]; ?>" class="main-logo  desktop-dark" alt="Painel Streaming">
                                <?php } else { ?>
                                <img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
                                <img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
                                <?php } ?>
                                <img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
                                <img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
                            </a>
                        </div>
                        <?php require_once("menu.php");?>
                    </aside>
                </div>
                <!-- main-sidebar -->
            </div>

            <!-- main-content -->
            <div class="main-content app-content">

                <!-- container -->
                <div class="main-container container-fluid">

                    <!-- breadcrumb -->
                    <div class="breadcrumb-header justify-content-between" style="padding-top:60px">
                        <div class="left-content">
                          <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo $lang['lang_acao_espectadores_stats']; ?></span>
                        </div>
                        <div class="justify-content-center mt-2">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item tx-15"><a href="/dashboard">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo $lang['lang_acao_espectadores_stats']; ?></li>
                            </ol>
                        </div>
                    </div>
                    <!-- /breadcrumb -->

                    <!-- row -->
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header d-flex custom-card-header border-bottom-0 ">
                    <header class="card-title"><?php echo $lang['lang_info_estatisticas_registros_tab_titulo']; ?></header>
                  </div>
                <div class="card-body">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">
                                            <tr>
                                              <td width="25%" height="70" align="center"><i class='fa fa-users f-48 text-blue'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-user f-48 text-blue'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-bar-chart-o f-48 text-blue'></i></td>
                                              <td width="25%" align="center"><i class='fa fa-clock-o f-48 text-blue'></i></td>
                                            </tr>
                                            <tr>
                                              <td height="30" align="center"><?php echo $total_espectadores_db; ?><br /><?php echo $lang['lang_info_estatisticas_total_espectadores']; ?></td>
                                              <td align="center"><?php echo $total_espectadores_unicos_db; ?><br /><?php echo $lang['lang_info_estatisticas_total_espectadores_unicos']; ?></td>
                                              <td align="center"><?php echo $total_espectadores_db; ?><br /><?php echo $lang['lang_info_estatisticas_total_espectadores_pico']; ?></td>
                                              <td align="center"><?php echo seconds2time($average_espectadores); ?><br /><?php echo $lang['lang_info_estatisticas_total_espectadores_tempo_conectados']; ?></td>
                                            </tr>
                                          </table>
                </div>
              </div>
            </div>        

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header d-flex custom-card-header border-bottom-0 ">
                    <header class="card-title"><?php echo $lang['lang_info_estatisticas_estatistica']; ?></header>
                  </div>
                <div class="card-body">
                    <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="120" height="50" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_estatisticas_estatistica']; ?></td>
                                            <td align="left">
                                            <select name="estatistica" class="form-control" id="estatistica" style="width:100%;" onchange="tipo_estatistica(this.value);">
                                              <option value="1"><?php echo $lang['lang_info_estatisticas_estatistica_espectadores']; ?></option>
                                              <option value="2"><?php echo $lang['lang_info_estatisticas_estatistica_tempo_conectado']; ?></option>
                                              <option value="3"><?php echo $lang['lang_info_estatisticas_estatistica_paises']; ?></option>
                                              <option value="4"><?php echo $lang['lang_info_estatisticas_estatistica_players']; ?></option>
                                              <option value="5"><?php echo $lang['lang_info_estatisticas_estatistica_espectadores_hora']; ?></option>
                                            </select>
                                            </td>
                                          </tr>
                                          <tr>
                                            <td colspan="2" align="left">
                                            <table width="100%" border="0" cellspacing="0" cellpadding="0" id="tabela_data">
                                              <tr>
                                                <td width="120" height="50" align="left" style="padding-left:5px;"><?php echo $lang['lang_info_estatisticas_periodo']; ?></td>
                                            <td align="left"><div class="input-group">
                                            <select name="mes" class="form-control" id="mes" style="width:162px;">
                                              <option value="01" <?php if(date("m") == '01') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_01']; ?></option>
                                              <option value="02" <?php if(date("m") == '02') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_02']; ?></option>
                                              <option value="03" <?php if(date("m") == '03') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_03']; ?></option>
                                              <option value="04" <?php if(date("m") == '04') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_04']; ?></option>
                                              <option value="05" <?php if(date("m") == '05') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_05']; ?></option>
                                              <option value="06" <?php if(date("m") == '06') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_06']; ?></option>
                                              <option value="07" <?php if(date("m") == '07') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_07']; ?></option>
                                              <option value="08" <?php if(date("m") == '08') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_08']; ?></option>
                                              <option value="09" <?php if(date("m") == '09') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_09']; ?></option>
                                              <option value="10" <?php if(date("m") == '10') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_10']; ?></option>
                                              <option value="11" <?php if(date("m") == '11') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_11']; ?></option>
                                              <option value="12" <?php if(date("m") == '12') { echo ' selected="selected"'; } ?>><?php echo $lang['lang_info_estatisticas_periodo_12']; ?></option>
                                            </select>&nbsp;
                                            <select name="ano" class="form-control" id="ano" style="width:90px;">
                                                <?php
                                                    $ano_inicial = date("Y")-1;
                                                    $ano_final = date("Y")+1;
                                                    $qtd = $ano_final-$ano_inicial;
                                                        for($i=0; $i <= $qtd; $i++) {
                                                                if(sprintf("%02s",$ano_inicial+$i) == date("Y")) {
                                                                    echo "<option value=\"".sprintf("%02s",$ano_inicial+$i)."\" selected=\"selected\">".sprintf("%02s",$ano_inicial+$i)."</option>\n";
                                                                } else {
                                                                    echo "<option value=\"".sprintf("%02s",$ano_inicial+$i)."\">".sprintf("%02s",$ano_inicial+$i)."</option>\n";
                                                                }
                                                        }
                                                ?>
                                            </select></div>
                                            </td>
                                              </tr>
                                            </table>
                                            </td>
                                          </tr>
                                          <tr>
                                            <td height="50" colspan="2" align="right"><button type="button" class="btn btn-info" onclick="window.location = '/estatisticas/'+document.getElementById('estatistica').value+'/'+document.getElementById('mes').value+'/'+document.getElementById('ano').value+'';"><?php echo $lang['lang_botao_titulo_visualizar']; ?></button></td>
                                          </tr>
                                        </table>
                </div>
              </div>
            </div>        
            <?php if(!empty($estatistica)) { ?>
            <div class="col-lg-12">
              <div class="card">
                <div class="card-body text-center">
                    <?php if($estatistica == "1") { ?>

<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'area'
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_info_stats_espectadores']; ?>'
            },
            subtitle: {
                text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano; ?>'
            },
            xAxis: {
                categories: [
                <?php
                $array_dias_meses = array("01" => "31", "02" => "29", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");
                
                for($i=1;$i<=$array_dias_meses[$mes];$i++){
                
                $dias .= sprintf("%02s",$i).",";

                }
                
                echo substr($dias, 0, -1);          
                ?>              
                ],
                tickmarkPlacement: 'on',
                title: {
                    enabled: false
                }
            },
            yAxis: {
                title: {
                    text: '<?php echo $lang['lang_info_estatisticas_info_stats_espectadores_total']; ?>'
                },
                labels: {
                    formatter: function() {
                        return this.value;
                    }
                }
            },
            tooltip: {
                formatter: function() {
                    return ''+
                        this.x +'/<?php echo $mes;?>/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_espectadores']; ?>';
                }
            },
            plotOptions: {
                area: {
                    stacking: 'normal',
                    lineColor: '#666666',
                    lineWidth: 1,
                    cursor: 'pointer',
                    marker: {
                        lineWidth: 1,
                        lineColor: '#666666',
                        enabled: false,
                        symbol: 'circle',
                        radius: 2,
                        states: {
                            hover: {
                            enabled: true
                            }
                        }
                    }
                }
            },
            series: [{
                name: '<?php echo $lang['lang_info_estatisticas_estatistica_espectadores']; ?>',
                data: [
                <?php
                
                for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){
                
                $dia = sprintf("%02s",$i);
                
                $total_espectadores = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND DAY(data) = '".$dia."'"));
                
                echo $total_espectadores.",";
                echo "\n";
                
                }
                ?>
                ]
            }]
        });
    });
    
});
</script>

<?php } else if($estatistica == "2") { ?>

<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'area'
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_info_stats_tempo_conectado']; ?>'
            },
            subtitle: {
                text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano;?>'
            },
            xAxis: {
                categories: [
                <?php
                $array_dias_meses = array("01" => "31", "02" => "28", "03" => "31", "04" => "30", "05" => "31", "06" => "30", "07" => "31", "08" => "31", "09" => "30", "10" => "31", "11" => "30", "12" => "31");
                
                for($i=1;$i<=$array_dias_meses[$mes];$i++){
                
                $dias .= sprintf("%02s",$i).",";

                }
                
                echo substr($dias, 0, -1);          
                ?>              
                ],
                tickmarkPlacement: 'on',
                title: {
                    enabled: false
                }
            },
            yAxis: {
                title: {
                    text: '<?php echo $lang['lang_info_estatisticas_info_stats_tempo_conectado_tempo_minutos']; ?>'
                },
                labels: {
                    formatter: function() {
                        return this.value;
                    }
                }
            },
            tooltip: {
                formatter: function() {
                    return ''+
                        this.x +'/<?php echo $mes;?>/<?php echo $ano;?>: '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_minutos']; ?>';
                }
            },
            plotOptions: {
                area: {
                    stacking: 'normal',
                    lineColor: '#666666',
                    lineWidth: 1,
                    cursor: 'pointer',
                    marker: {
                        lineWidth: 1,
                        lineColor: '#666666',
                        enabled: false,
                        symbol: 'circle',
                        radius: 2,
                        states: {
                            hover: {
                            enabled: true
                            }
                        }
                    }
                }
            },
            series: [{
                name: '<?php echo $lang['lang_info_estatisticas_info_stats_tempo_conectado_tempo_minutos']; ?>',
                data: [
                <?php
                for($i=1;$i<=$array_dias_meses["".$mes.""];$i++){
                
                $dia = sprintf("%02s",$i);
                
                $soma = 0;
                $contador = 0;
                
                $query = mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND DAY(data) = '".$dia."'");
                
                while ($dados_estatistica = mysqli_fetch_array($query)) {

                $soma += $dados_estatistica["tempo_conectado"];
                $contador++;

                }
                
                $media = ($contador > 0) ? $soma / $contador : '0';
                
                echo date('i',mktime(0,0,$media,15,03,2013)).",";
                echo "\n";
                
                }
                ?>
                ]
            }]
        });
    });
    
});

</script>

<?php } else if($estatistica == "3") { ?>

<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'pie',
                    options3d: {
                        enabled: true,
                        alpha: 45,
                        beta: 0
                    }
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_info_stats_pais']; ?>'
            },
            tooltip: {
                formatter: function() {
                    return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                }
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    depth: 35,
                    dataLabels: {
                        enabled: true
                    },
                    showInLegend: true
                }
            },
            series: [{
                type: 'pie',
                name: '<?php echo $lang['lang_info_estatisticas_info_stats_pais_espectadores']; ?>',
                data: [
                
                <?php
                
                $sql_paises = mysqli_query($conexao,"SELECT distinct(pais) as pais, count(pais) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' GROUP by pais ORDER by total DESC LIMIT 5");
                while ($dados_pais_ip = mysqli_fetch_array($sql_paises)) {

                if($dados_pais_ip["total"] > 1) {
                
                echo "['".$dados_pais_ip["pais"]."', ".$dados_pais_ip["total"]."],";
                echo "\n";

                }

                }
                
                ?>

                ]
            }]
        });
    });
    
});
</script>

<?php } else if($estatistica == "4") { ?>

<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'pie',
                    options3d: {
                        enabled: true,
                        alpha: 45,
                        beta: 0
                    }
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_info_stats_players']; ?>'
            },
            tooltip: {
                formatter: function() {
                    return '<b>'+ this.point.name +'</b>: '+ Highcharts.numberFormat(this.percentage, 0, ',') +' %';
                }
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    depth: 35,
                    dataLabels: {
                        enabled: true
                    },
                    showInLegend: true
                }
            },
            series: [{
                type: 'pie',
                data: [
                
                <?php
                
                $sql_players = mysqli_query($conexao,"SELECT distinct(player) as player, count(player) as total FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND player != '' GROUP by player ORDER by total DESC");
                while ($dados_player = mysqli_fetch_array($sql_players)) {

                if($dados_player["total"] > 0) {
                
                echo "['".$dados_player["player"]."', ".$dados_player["total"]."],";
                echo "\n";

                }

                }
                
                ?>

                ]
            }]
        });
    });
    
});
</script>

<?php } else if($estatistica == "5") { ?>
<script type="text/javascript">

$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'area'
            },
            title: {
                text: '<?php echo $lang['lang_info_estatisticas_estatistica_espectadores_hora']; // espectadores Conectados por Hora ?>'
            },
            subtitle: {
                text: '<?php echo $lang['lang_info_estatisticas_periodo_'.$mes.'']; ?> <?php echo $ano;?>'
            },
            xAxis: {
                categories: ['00:00-00:59','01:00-01:59','02:00-02:59','03:00-03:59','04:00-04:59','05:00-05:59','06:00-06:59','07:00-07:59','08:00-08:59','09:00-09:59','10:00-10:59','11:00-11:59','12:00-12:59','13:00-13:59','14:00-14:59','15:00-15:59','16:00-16:59','17:00-17:59','18:00-18:59','19:00-19:59','20:00-20:59','21:00-21:59','22:00-22:59','23:00-23:59'],
                tickmarkPlacement: 'on',
            },
            yAxis: {
                title: {
                    text: '<?php echo $lang['lang_info_estatisticas_info_stats_espectadores_total']; // Total de espectadores ?>'
                },
                labels: {
                    formatter: function() {
                        return this.value;
                    }
                }
            },
            tooltip: {
                formatter: function() {
                    return ''+this.x+': '+ Highcharts.numberFormat(this.y, 0, ',') +' <?php echo $lang['lang_info_estatisticas_legenda_espectadores']; // ouvinte(s) ?>';
                }
            },
            plotOptions: {
                area: {
                    stacking: 'normal',
                    lineColor: '#666666',
                    lineWidth: 1,
                    cursor: 'pointer',
                    marker: {
                        lineWidth: 1,
                        lineColor: '#666666',
                        enabled: false,
                        symbol: 'circle',
                        radius: 2,
                        states: {
                            hover: {
                            enabled: true
                            }
                        }
                    }
                }
            },
            series: [{
                name: '<?php echo $lang['lang_info_estatisticas_estatistica_espectadores']; ?>',
                data: [<?php
                
                for($i=0;$i<=23;$i++){
                
                $hora = sprintf("%02s",$i);
                
                $total_espectadores = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM estatisticas where codigo_stm = '".$dados_stm["codigo"]."' AND YEAR(data) = '".$ano."' AND MONTH(data) = '".$mes."' AND HOUR(hora) = '".$hora."'"));
                
                $array_total_espectadores .= $total_espectadores.",";
                
                }
                echo substr($array_total_espectadores, 0, -1);  
                
                unset($array_total_espectadores);
                unset($total_espectadores);
                ?>]
            }]
        });
    });
    
});

</script>
<?php } ?>
<div id="container" style="min-width: 100%; height: auto; margin: 0 auto"></div>
                </div>
              </div>
            </div>
<?php } ?>
          <!-- cards closed -->
                    </div>
                    <!-- row closed -->
                </div>
                <!-- Container closed -->
            </div>
            <!-- main-content closed -->

            <!-- Country-selector modal-->
            <div class="modal fade" id="country-selector">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header border-bottom">
                            <h6 class="modal-title"><?php echo $lang['lang_info_config_painel_idioma']; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
                        </div>
                        <div class="modal-body">
                            <ul class="row p-3">
                                <li class="col-lg-6 mb-2">
                                    <a href="/mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "es") { ?>active<?php } ?>">
                                        <span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
                                    </a>
                                </li>
                                <li class="col-lg-6 mb-2 mb-2">
                                    <a href="/mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
                                        <span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
                                    </a>
                                </li>
                                <li class="col-lg-6 mb-2">
                                    <a href="/mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_stm["idioma_painel"] == "en") { ?>active<?php } ?>">
                                        <span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Modal -->
            <?php require_once("modal.php");?>
        </div>
        <!-- End Page -->
        <a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
        <script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
        <script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
        <script src="/inc/plugins/side-menu/sidemenu.js"></script>
        <script src="/inc/js/theme.js"></script>
        <script src="/inc/theme-<?php echo $dados_stm["layout_painel"]; ?>.js"></script>
  
  <script>
  status_streaming('<?php echo $login_code; ?>');
  setInterval("status_streaming('<?php echo $login_code; ?>')",60000);
  </script>
</body>
</html>