<?php
require_once("inc/protecao-admin.php");

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Administra&ccedil;&atilde;o</title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css"> 
  <link rel="stylesheet" href="/inc/summernote-bs4.css">   
  <link rel="stylesheet" href="/inc/theme.css">
  <link rel="shortcut icon" href="/img/favicon.ico" />
  <script type="text/javascript" src="/admin/inc/ajax.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>
<body>
  <div class="container-scroller">
    <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Administra&ccedil;&atilde;o</span></a>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><i class="fa fa-lock text-yellow"></i></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav mr-lg-2">
          <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        </ul>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>
    <div class="container-fluid page-body-wrapper">
      <nav class="sidebar sidebar-offcanvas" id="sidebar">
        <ul class="nav">
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-streamings">
              <i class="fa fa-headphones text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_streaming; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-revendas">
              <i class="fa fa-users text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_revenda; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-servidores">
              <i class="fa fa-tasks text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_servidor; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-avisos">
              <i class="fa fa-info-circle text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_avisos; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-tutoriais">
              <i class="fa fa-life-bouy text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_tutoriais; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-apps">
              <i class="fa fa-android text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_apps; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-logs-acoes">
              <i class="fa fa-file-text-o text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_logs_acoes; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-backup">
              <i class="fa fa-shield text-icones"></i>
              <span class="menu-title">Backup</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-estatisticas">
              <i class="fa fa-bar-chart-o text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_estatisticas; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-configuracoes">
              <i class="fa fa-cog text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_configuracoes; ?></span>
            </a>
          </li>   
        </ul>
      </nav>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header d-flex custom-card-header border-bottom-0 ">
                    <header><?php echo lang_pagina_tutoriais_cadastrar_titulo; ?></header>
                  </div>
                <div class="card-body">
                    <form method="post" action="/admin/admin-cadastra-tutorial" name="cadastrar">
                                        <table width="100%" border="0" align="center" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td width="105" height="35" align="left" style="padding-left:5px;"><strong><?php echo lang_pagina_tutoriais_cadastrar_titulo_tutorial; ?></strong></td>
                                            <td align="left"><input name="titulo" type="text" class="form-control" id="titulo" style="width:100%;" /></td>
                                          </tr>
                                          <tr>
                                            <td height="50" colspan="2"><textarea class="form-control html-editor" id="tutorial" name="tutorial" rows="10"></textarea></td>
                                          </tr>
                                          <tr>
                                            <td height="35" colspan="2" align="center"><button type="button" class="btn btn-info" onClick="document.cadastrar.submit();"><?php echo lang_botao_titulo_cadastrar; ?></button></td>
                                          </tr>
                                        </table>
                                      </form>
                </div>
              </div>
            </div>

          <!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo lang_pagina_configuracoes_idioma_painel; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/admin/admin-mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/admin/admin-mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<!--
								<li class="col-lg-6 mb-2">
									<a href="/admin/admin-mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>-->
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal-admin.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/summernote-bs4.min.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/admin-streamings/resultado/"+document.getElementById("busca_chave").value;
    }
  }); 
        $('.html-editor').summernote({
            height: 300,
            tabsize: 2
        }); 
  </script>
</body>
</html>